<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class BlogController extends Controller
{
    /**
     * Display a listing of the resource.
     */
  public function index()
  {
      $blog = DB::table("blogs")->whereSite('6')->where('language', app()->getLocale())->get();
      $contact = DB::table("contact_infos")->whereSite('6')->where('language', app()->getLocale())->first();
      $site = DB::table("sites")->whereId('6')->first();
      $city = DB::connection('mysql_rep')->table('iller')->get();
      $seo = DB::table("seos")->whereSite('6')->where('language', app()->getLocale())->first();
      $education = DB::table('educations')->whereSite('6')->where('language', app()->getLocale())->get();
      $blogs = DB::table('blogs')->whereSite('6')->where('language', app()->getLocale())->orderBy('created_at', 'desc')->get();

      return view('blogs', compact('blog', 'contact', 'site', 'city', 'seo', 'education', 'blogs'));
  }
    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
 public function show($slug)
 {
     $blog = DB::table('blogs')->where('slug', $slug)->whereSite('6')->where('language', app()->getLocale())->first();
     if (!$blog) {
         abort(404);
     }

     $blogs = DB::table('blogs')->whereSite('6')->whereNotIn('id', [$blog->id])->where('language', app()->getLocale())->get();
     $site = DB::table('sites')->whereId('6')->where('language', app()->getLocale())->first();
     $city = DB::connection('mysql_rep')->table('iller')->get();
     $seo = DB::table('seos')->whereSite('6')->where('language', app()->getLocale())->first();
     $contact = DB::table('contact_infos')->whereSite('6')->where('language', app()->getLocale())->first();
     $education = DB::table('educations')->whereSite('6')->where('language', app()->getLocale())->get();

     return view('blogs_detail', compact('blog', 'contact', 'site', 'blogs', 'city', 'seo', 'education'));
 }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
