<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class EducationController extends Controller

{
    public function index()
    {
        $education = DB::table('educations')
            ->where('site', '6')
            ->where('language', app()->getLocale())
            ->get();
    
        return view('education', compact('education'));
    }

    public function show($slug)
    {
        $education = DB::table('educations')
                       ->where('slug', $slug)
                       ->where('site', '6')
                       ->where('language', app()->getLocale())
                       ->first();
    
        if (!$education) {
            abort(404);
        }
    
        $educations = DB::table('educations')
                        ->where('site', '6')
                        ->where('language', app()->getLocale())
                        ->where('id', '!=', $education->id)
                        ->get();
    
        $site = DB::table('sites')
                  ->where('id', '6')
                  ->where('language', app()->getLocale())
                  ->first();
                  
        $city = DB::connection('mysql_rep')->table('iller')->get();
        $seo = DB::table('seos')
                 ->where('site', '6')
                 ->where('language', app()->getLocale())
                 ->first();
        $contact = DB::table('contact_infos')
                     ->where('site', '6')
                     ->where('language', app()->getLocale())
                     ->first();
    
        return view('educations_detail', compact('education', 'contact', 'site', 'educations', 'city', 'seo'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        abort(404);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        abort(404);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        abort(404);
    }
}
