<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ExamController extends Controller
{
     /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $exam      = DB::table("exams")->whereSite('6')->where('language',app()->getLocale())->get();
        $contact        = DB::table("contact_infos")->whereSite('6')->where('language',app()->getLocale())->first();
        $blog       = DB::table('blogs')->whereSite('6')->where('language',app()->getLocale())->get();
        $site           = DB::table("sites")->whereId('6')->first();
        $city           = DB::connection('mysql_rep')->table('iller')->get();
        $seo            = DB::table("seos")->whereSite('6')->where('language',app()->getLocale())->first();
        $education  = DB::table('educations')->whereSite('6')->where('language',app()->getLocale())->get();
        return view('exams', compact(['exam','contact', 'blog','site','city','seo','education']));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
         abort(404);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        abort(404);
    }

    /**
     * Display the specified resource.
     */
    public function show($slug)
    {

        $exam          = DB::table('exams')->where('slug',$slug)->whereSite('6')->where('language',app()->getLocale())->first();
        if (!$exam) {
            abort(404);
        }

        $exams         = DB::table('exams')->whereSite('6')->whereNotIn('id',[$exam->id])->where('language',app()->getLocale())->get();
        $site               = DB::table('sites')->whereId('6')->where('language',app()->getLocale())->first();
        $city               = DB::connection('mysql_rep')->table('iller')->get();
        $seo                = DB::table('seos')->whereSite('6')->where('language',app()->getLocale())->first();
        $contact            = DB::table('contact_infos')->whereSite('6')->where('language',app()->getLocale())->first();
        return view('exams_detail', compact(['exam','contact','site','exams','city','seo']));
    }
    //ffrere    exams_detail

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        abort(404);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        abort(404);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        abort(404);
    }
}