<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;

class HomeController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        try {
            $datetime = Carbon::now('Europe/Istanbul');
            
            // Veritabanı bağlantısını kontrol et
            try {
                DB::connection()->getPdo();
                Log::info('Database connection successful');
            } catch (\Exception $e) {
                Log::error('Database connection failed: ' . $e->getMessage());
            }
            
            // Site bilgisini al
            $site = DB::table('sites')->whereId('6')->first();
            Log::info('Site data:', ['site' => $site]);
            
            // Dil bilgisini al
            $currentLocale = app()->getLocale();
            Log::info('Current locale:', ['locale' => $currentLocale]);
            
            // Slider verilerini al
            $slider = DB::table('sliders')
                ->whereSite('6')
                ->where('language', $currentLocale)
                ->get();
            
            Log::info('Slider data:', [
                'count' => $slider->count(),
                'data' => $slider,
                'query' => DB::table('sliders')
                    ->whereSite('6')
                    ->where('language', $currentLocale)
                    ->toSql()
            ]);

            // Diğer verileri al
            $about = DB::table('abouts')->where('language', $currentLocale)->whereSite('6')->first();
            $seo = DB::table('seos')->whereSite('6')->where('language', $currentLocale)->first();
            $contact = DB::table('contact_infos')->whereSite('6')->where('language', $currentLocale)->first();
            $education = DB::table('educations')->whereSite('6')->where('language', $currentLocale)->get();
            $blog = DB::table('blogs')->whereSite('6')->where('language', $currentLocale)->get();
            $exam = DB::table('exams')->whereSite('6')->where('language', $currentLocale)->get();
            $video = DB::table('videos')->whereSite('6')->where('language', $currentLocale)->get();
            $whyuse = DB::table('why_uses')->where('language', $currentLocale)->where('site', '6')->get();
            $reference = DB::table('referans')->whereSite('6')->get();
            $katilimcilar = [];

            // Yapılandırma bilgilerini kontrol et
            Log::info('Configuration:', [
                'storage_url' => config('app.storage'),
                'app_url' => config('app.url'),
                'asset_url' => config('app.asset_url')
            ]);

            return view('welcome', compact([
                'seo', 'contact', 'slider', 'exam', 'education', 
                'site', 'reference', 'about', 'blog', 
                'katilimcilar', 'whyuse'
            ]));
            
        } catch (\Exception $e) {
            Log::error('Error in HomeController@index:', [
                'message' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ]);
            throw $e;
        }
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
