<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class QuoteFormRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'AdSoyad' => 'required|string|max:255',
            'SirketAdi' => 'required|string|max:255',
            'Telefon' => 'required|string|max:20',
            'Email' => 'required|email',
            'Mesaj' => 'required|string|max:1000',
            'visit_time' => 'required|numeric'
        ];
    }

    public function messages()
    {
        return [
            'AdSoyad.required' => 'Ad Soyad alanı zorunludur.',
            'SirketAdi.required' => 'Şirket adı alanı zorunludur.',
            'Telefon.required' => 'Telefon alanı zorunludur.',
            'Email.required' => 'E-posta alanı zorunludur.',
            'Email.email' => 'Geçerli bir e-posta adresi giriniz.',
            'Mesaj.required' => 'Mesaj alanı zorunludur.'
        ];
    }
}
