<?php

namespace App\Services;

use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use Monolog\Logger;
use Monolog\Handler\RotatingFileHandler;
use Monolog\Formatter\LineFormatter;

class LogService
{
    protected $logger;

    public function __construct()
    {
        $this->logger = Log::channel('custom');
    }

    public function logInfo(string $action, array $data = [], string $model = null)
    {
        $this->log('info', $action, $data, $model);
    }

    public function logError(string $action, array $data = [], string $model = null, \Throwable $exception = null)
    {
        $errorData = $data;
        if ($exception) {
            $errorData['exception'] = [
                'message' => $exception->getMessage(),
                'file' => $exception->getFile(),
                'line' => $exception->getLine(),
                'trace' => $exception->getTraceAsString()
            ];
        }

        $this->log('error', $action, $errorData, $model);
    }

    public function logWarning(string $action, array $data = [], string $model = null)
    {
        $this->log('warning', $action, $data, $model);
    }

    protected function log(string $level, string $action, array $data, ?string $model)
    {
        $logData = [
            'timestamp' => now()->format('Y-m-d H:i:s'),
            'ip' => request()->ip(),
            'user_id' => Auth::id(),
            'action' => $action,
            'model' => $model,
            'url' => request()->fullUrl(),
            'method' => request()->method(),
            'user_agent' => request()->userAgent(),
            'data' => $data
        ];

        $this->logger->{$level}(json_encode($logData, JSON_PRETTY_PRINT));
    }
}
