@extends('layouts.app')

@section('css')
@endsection
@section('title')
    Amerikan Kültür Kurumsal
@endsection

@section('content')
    <section class="breadcrumb__area breadcrumb__bg" data-background="assets/img/akdweb.jpg">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <div class="breadcrumb__content">
                        <h2 class="title">{{ __('Blog') }}</h2>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{ route('home') }}">{{ __('Home') }}</a></li>
                                <li class="breadcrumb-item active" aria-current="page">{{ __('Blog') }}</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
        <div class="breadcrumb__shape">
            <img src="assets/img/images/breadcrumb_shape05.png" alt="" class="alltuchtopdown">
        </div>
    </section>

    <section class="blog__area">
        <div class="container">
            <div class="blog__inner-wrap">
                <div class="blog-post-wrap">
                    <div class="row gutter-24">
                        @foreach ($blog as $blog)
                            <div class="col-md-6">
                                <div class="blog__post-two shine-animate-item">
                                    <div class="blog__post-thumb-two">
                                        <a class="shine-animate" href="{{ route('blog', $blog->slug) }}">
                                            <img src="{{ config('app.storage') . $blog->image }}" alt="{{ $blog->header }}">
                                        </a>
                                    </div>
                                    <div class="blog__post-content-two">
                                        <div class="blog-post-meta">

                                        </div>
                                        <h2 class="title"><a
                                                href="{{ route('blog.show', $blog->slug) }}">{{ $blog->title }}</a></h2>
                                        <div class="blog-avatar">
                                            <div class="avatar-thumb">
                                            
                                            </div>
                                            <div class="avatar-content">

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                    <div class="pagination-wrap mt-40">
                        <!-- Pagination -->
                    </div>
                </div>

                <aside class="blog__sidebar">
                    <div class="sidebar_widget sidebar_widget-two">
                        <div class="sidebar__search">

                        </div>
                    </div>
                    <div class="sidebar__widget">
                        <h4 class="sidebar__widget-title">{{ __('Recently Posted') }}</h4>
                        <div class="sidebar__cat-list">
                            <ul class="list-wrap">
                                @foreach ($blogs as $post)
                                    <li>
                                        <a href="{{ route('blog.show', $post->slug) }}"><i
                                                class="flaticon-arrow-button"></i>{{ $post->header }}</a>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>


                    <div class="sidebar__widget">
                        <h4 class="sidebar__widget-title">{{ __('Popular Tags') }}</h4>
                        <div class="sidebar__tag-list">
                            <ul class="list-wrap">
                                <li><a href="#">#{{ __('corporateenglishtrainingpackage') }}</a></li>
                                <li><a href="#">#{{ __('generalenglish') }}</a></li>
                                <li><a href="#">#{{ __('corporateenglish') }}</a></li>
                                <li><a href="#">#{{ __('businessenglish') }}</a></li>
                                <li><a href="#">#{{ __('speakingclubs') }}</a></li>

                            </ul>
                        </div>
                    </div>
                </aside>
            </div>
        </div>
    </section>
    <style>

    </style>
@endsection
