@extends('layouts.app')
@section('css')
@endsection
@section('title')
    Amerikan Kültür Kurumsal
@endsection
@section('content')
    <section class="breadcrumb__area breadcrumb__bg" data-background="assets/img/akdweb.jpg">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <div class="breadcrumb__content">
                        <h2 class="title">{{ __('Contact') }}</h2>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{ route('home') }}">{{ __('Home') }}</a></li>
                                <li class="breadcrumb-item active" aria-current="page">{{ __('Contact') }}</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
        <div class="breadcrumb__shape">
            <img src="assets/img/images/breadcrumb_shape05.png" alt="" class="alltuchtopdown">
        </div>
    </section>

    <section class="contact__area">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">

                </div>
            </div>
            <div class="row align-items-center">
                <div class="col-lg-5">
                    <div class="contact__content">
                        <div class="section-title mb-35">
                            <h2 class="title">{{ __('How can we help you?') }}</h2>
                            <p></p>
                        </div>
                        <div class="contact__info">
                            <ul class="list-wrap">
                                <li>
                                    <div class="icon">
                                        <i class="flaticon-pin"></i>
                                    </div>
                                    <div class="content">
                                        <h4 class="title">{{ __('Address') }}</h4>
                                        <p>Merkez Mah. Abide-i Hürriyet Cad. No:211/73 Kat:4 Blackout Avm 34381
                                            Şişli/İstanbul</p>
                                    </div>
                                </li>
                                <li>
                                    <div class="icon">
                                        <i class="flaticon-phone-call"></i>
                                    </div>
                                    <div class="content">
                                        <h4 class="title">{{ __('Phone') }}</h4>
                                        <a href="tel:0850 80 80 453">0850 80 80 453</a>
                                    </div>
                                </li>
                                <li>
                                    <div class="icon">
                                        <i class="flaticon-mail"></i>
                                    </div>
                                    <div class="content">
                                        <h4 class="title">{{ __('Email') }}</h4>
                                        <a href="bilgi@amerikankulturkurumsal.com">bilgi@amerikankulturkurumsal.com</a>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-lg-7">
                    <div class="contact__form-wrap">
                        <h2 class="title">{{ __('Give Us a Message') }}</h2>
                        <br>
                        <div id="alert-box" style="display: none;"></div>


                        <script src="https://www.google.com/recaptcha/api.js" async defer></script>


                        <form id="contact-form" action="{{ route('contact.submit') }}" method="POST">
                            @csrf
                            <input type="hidden" name="visit_time" value="{{ time() }}">
                            <input type="text" name="hiddenField" style="display:none;">

                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-grp">
                                        <input type="text" name="name" placeholder="{{ __('Name-Surname') }}"
                                            required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-grp">
                                        <input type="email" name="email" placeholder="{{ __('Email') }}" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-grp">
                                        <input type="text" name="phone" placeholder="{{ __('Phone Number') }}"
                                            required>
                                    </div>
                                </div>
                                <div class="form-grp">
                                    <textarea name="message" placeholder="{{ __('Message') }}" required></textarea>
                                </div>
                            </div>

                            <div class="form-grp mb-30">
                                <textarea name="subject" placeholder="{{ __('Subject') }}" required></textarea>
                            </div>

                            <!-- reCAPTCHA Alanı -->
                            <div class="form-group text-center">
                                <div class="g-recaptcha" data-sitekey="{{ env('RECAPTCHA_SITE_KEY') }}"
                                    data-callback="enableSubmit" data-expired-callback="disableSubmit"></div>
                                <span id="captcha-error" class="text-danger mt-2" style="display: none;">Lütfen reCAPTCHA
                                    doğrulamasını tamamlayın.</span>
                            </div>

                            <div class="text-center mt-4">
                                <button type="submit" id="submit-button" class="btn btn-primary w-100" disabled>
                                    {{ __('Send Message') }} <i class="far fa-paper-plane"></i>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>


                <script>
                    function enableSubmit() {
                        let submitButton = document.getElementById("submit-button");
                        submitButton.disabled = false;
                    }


                    function disableSubmit() {
                        let submitButton = document.getElementById("submit-button");
                        submitButton.disabled = true;
                    }

                    document.addEventListener("DOMContentLoaded", function() {
                        let form = document.getElementById("contact-form");
                        let captchaError = document.getElementById("captcha-error");

                        form.addEventListener("submit", function(event) {
                            let recaptchaResponse = grecaptcha.getResponse();

                            if (!recaptchaResponse) {
                                event.preventDefault();
                                captchaError.style.display = "block";
                                captchaError.innerHTML = "Lütfen reCAPTCHA doğrulamasını tamamlayın.";
                            } else {
                                captchaError.style.display = "none";
                            }
                        });
                    });
                </script>






    </section>
@endsection
