<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\QuoteController;
use App\Http\Controllers\EducationController;
use App\Http\Controllers\AgreementController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::middleware(['language'])->group(function () {
    Route::get('/', [\App\Http\Controllers\HomeController::class,'index'])->name('home');
    Route::get('/about', [\App\Http\Controllers\AboutController::class,'index'])->name('about');
    Route::get('/education', [\App\Http\Controllers\EducationController::class,'index'])->name('education');
    Route::get('/education/{slug}', [\App\Http\Controllers\EducationController::class,'show'])->name('education.show');
    Route::get('/blog', [\App\Http\Controllers\BlogController::class,'index'])->name('blog');
    Route::get('/blog/{slug}', [\App\Http\Controllers\BlogController::class,'show'])->name('blog.show');
    Route::get('/exam', [\App\Http\Controllers\ExamController::class,'index'])->name('exam');
    Route::get('/exam/{slug}', [\App\Http\Controllers\ExamController::class,'show'])->name('exam.show');
    Route::get('/contact', [\App\Http\Controllers\ContactController::class, 'getContactInfo'])->name('contact');
    Route::post('/contact', [\App\Http\Controllers\ContactController::class, 'submitContactForm'])->name('contact.submit');

    Route::get('/president', [\App\Http\Controllers\PresidentController::class, 'index'])->name('president');
    Route::get('/why-use', [\App\Http\Controllers\WhyUseController::class, 'index'])->name('why-use');
    Route::get('/trainingpackage', [\App\Http\Controllers\TrainingPackageController::class, 'index'])->name('trainingpackage');
    Route::get('/reference', [\App\Http\Controllers\ReferenceController::class, 'index'])->name('reference');

    Route::get('/agreement', [\App\Http\Controllers\AgreementController::class, 'agreement'])->name('agreement');
    Route::get('/privacy-policy', function () {
        return view('privacy');
    })->name('privacy');
});

// Quote submission route
Route::post('/submit-quote', [QuoteController::class, 'store'])
    ->name('quote.store');

// Education Routes
Route::group(['prefix' => 'education', 'middleware' => 'language'], function() {
    Route::get('/', [EducationController::class, 'index'])
        ->name('education');

    Route::get('/{slug}', [EducationController::class, 'show'])
        ->name('education.show');
});

// Language setting route
Route::get('set-locale/{locale}', function ($locale) {
    app()->setLocale($locale);
    session()->put('locale', $locale);

    return redirect()->route('home');
})->name('locale.setting');

// Thank you page (without language middleware)
Route::get('/thanks', function () {
    return view('thanks');
})->name('thanks')->withoutMiddleware('language');
Route::get('/business-thanks', function () {
    return view('business_thanks');
})->name('business_thanks')->withoutMiddleware('language');

// Agreement Route
Route::get('/agreement', [AgreementController::class, 'agreement'])
    ->name('agreement')
    ->middleware('language');
