<div class="gdpr-notice" id="gdprNotice" style="display: none;">
    <div class="gdpr-icon">🍪</div>
    <div class="gdpr-notice-content">
        <p>
            Size daha iyi bir deneyim sunmak için çerezleri kullanıyoruz. 
            <a href="<?php echo e(route('privacy')); ?>" class="gdpr-link">Detaylı bilgi</a>
        </p>
        <div class="gdpr-buttons">
            <button id="gdprSettings" class="gdpr-button gdpr-settings">Ayarlar</button>
            <button id="gdprAccept" class="gdpr-button gdpr-accept">Kabul Et</button>
        </div>
    </div>
</div>

<!-- Ayarlar Modal -->
<div class="gdpr-settings-modal" id="gdprSettingsModal" style="display: none;">
    <div class="gdpr-settings-content">
        <div class="gdpr-settings-header">
            <h3>🔒 Gizlilik Tercihleri</h3>
            <button class="gdpr-settings-close" id="gdprSettingsClose">&times;</button>
        </div>
        
        <div class="gdpr-settings-body">
            <p class="gdpr-settings-intro">
                Gizliliğiniz bizim için önemli. Tercihlerinizi istediğiniz zaman güncelleyebilirsiniz.
            </p>
            
            <div class="gdpr-setting-item">
                <label class="gdpr-switch">
                    <input type="checkbox" checked disabled>
                    <span class="gdpr-slider"></span>
                </label>
                <div class="gdpr-setting-text">
                    <h4>Gerekli Çerezler</h4>
                    <p>Web sitesinin temel işlevleri için gereklidir.</p>
                </div>
            </div>

            <div class="gdpr-setting-item">
                <label class="gdpr-switch">
                    <input type="checkbox" id="analyticsConsent">
                    <span class="gdpr-slider"></span>
                </label>
                <div class="gdpr-setting-text">
                    <h4>Analitik Çerezler</h4>
                    <p>Sitemizi nasıl kullandığınızı anlamamıza yardımcı olur.</p>
                </div>
            </div>

            <div class="gdpr-setting-item">
                <label class="gdpr-switch">
                    <input type="checkbox" id="marketingConsent">
                    <span class="gdpr-slider"></span>
                </label>
                <div class="gdpr-setting-text">
                    <h4>Pazarlama Çerezleri</h4>
                    <p>Size özel içerik ve reklamlar sunmamızı sağlar.</p>
                </div>
            </div>
        </div>

        <div class="gdpr-settings-footer">
            <button id="gdprReject" class="gdpr-button gdpr-reject">Sadece Gerekli Olanları Kabul Et</button>
            <button id="gdprSettingsSave" class="gdpr-button gdpr-accept">Seçili Tümünü Kabul Et</button>
        </div>
    </div>
</div>

<style>
.gdpr-notice {
    position: fixed;
    bottom: 30px;
    right: 30px;
    background: white;
    color: #333;
    padding: 1rem;
    z-index: 9999;
    border-radius: 10px;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
    max-width: 400px;
    display: flex;
    gap: 1rem;
    align-items: flex-start;
    animation: slideIn 0.5s ease-out;
}

.gdpr-icon {
    font-size: 24px;
    line-height: 1;
}

.gdpr-notice-content {
    flex: 1;
}

.gdpr-notice p {
    margin: 0 0 0.8rem 0;
    font-size: 0.9rem;
    line-height: 1.4;
}

.gdpr-link {
    color: #2196F3;
    text-decoration: none;
    font-weight: 600;
}

.gdpr-link:hover {
    text-decoration: underline;
}

.gdpr-buttons {
    display: flex;
    gap: 0.5rem;
}

.gdpr-button {
    padding: 0.5rem 1rem;
    border: none;
    border-radius: 5px;
    cursor: pointer;
    font-weight: 600;
    font-size: 0.9rem;
    transition: all 0.2s ease;
}

.gdpr-accept {
    background: #4CAF50;
    color: white;
}

.gdpr-accept:hover {
    background: #45a049;
}

.gdpr-reject {
    background: #f5f5f5;
    color: #666;
}

.gdpr-reject:hover {
    background: #e0e0e0;
}

.gdpr-settings {
    background: #2196F3;
    color: white;
}

.gdpr-settings:hover {
    background: #1976D2;
}

/* Modal Styles */
.gdpr-settings-modal {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0, 0, 0, 0.5);
    display: flex;
    justify-content: center;
    align-items: center;
    z-index: 10000;
    animation: fadeIn 0.3s ease-out;
}

.gdpr-settings-content {
    background: white;
    border-radius: 10px;
    width: 90%;
    max-width: 500px;
    max-height: 90vh;
    overflow-y: auto;
    animation: modalSlideIn 0.3s ease-out;
}

.gdpr-settings-header {
    padding: 1.5rem;
    border-bottom: 1px solid #eee;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.gdpr-settings-header h3 {
    margin: 0;
    color: #333;
    font-size: 1.2rem;
}

.gdpr-settings-close {
    background: none;
    border: none;
    font-size: 1.5rem;
    cursor: pointer;
    color: #666;
    padding: 0;
    line-height: 1;
}

.gdpr-settings-body {
    padding: 1.5rem;
}

.gdpr-settings-intro {
    margin: 0 0 1.5rem 0;
    color: #666;
    font-size: 0.9rem;
    line-height: 1.5;
}

.gdpr-setting-item {
    display: flex;
    gap: 1rem;
    padding: 1rem 0;
    border-bottom: 1px solid #eee;
}

.gdpr-setting-item:last-child {
    border-bottom: none;
}

.gdpr-setting-text h4 {
    margin: 0 0 0.3rem 0;
    color: #333;
    font-size: 1rem;
}

.gdpr-setting-text p {
    margin: 0;
    color: #666;
    font-size: 0.9rem;
}

.gdpr-settings-footer {
    padding: 1rem 1.5rem;
    border-top: 1px solid #eee;
    display: flex;
    justify-content: flex-end;
    gap: 1rem;
}

/* Switch Styles */
.gdpr-switch {
    position: relative;
    display: inline-block;
    width: 44px;
    height: 24px;
    flex-shrink: 0;
}

.gdpr-switch input {
    opacity: 0;
    width: 0;
    height: 0;
}

.gdpr-slider {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: #ccc;
    transition: .4s;
    border-radius: 24px;
}

.gdpr-slider:before {
    position: absolute;
    content: "";
    height: 18px;
    width: 18px;
    left: 3px;
    bottom: 3px;
    background-color: white;
    transition: .4s;
    border-radius: 50%;
}

input:checked + .gdpr-slider {
    background-color: #4CAF50;
}

input:disabled + .gdpr-slider {
    background-color: #9e9e9e;
    cursor: not-allowed;
}

input:checked + .gdpr-slider:before {
    transform: translateX(20px);
}

/* Animations */
@keyframes slideIn {
    from {
        transform: translateY(100px);
        opacity: 0;
    }
    to {
        transform: translateY(0);
        opacity: 1;
    }
}

@keyframes fadeIn {
    from {
        opacity: 0;
    }
    to {
        opacity: 1;
    }
}

@keyframes modalSlideIn {
    from {
        transform: translateY(50px);
        opacity: 0;
    }
    to {
        transform: translateY(0);
        opacity: 1;
    }
}

@media (max-width: 768px) {
    .gdpr-notice {
        bottom: 0;
        right: 0;
        left: 0;
        border-radius: 10px 10px 0 0;
        max-width: none;
        margin: 0;
    }
    
    .gdpr-settings-footer {
        flex-direction: column;
    }
    
    .gdpr-settings-footer .gdpr-button {
        width: 100%;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const gdprNotice = document.getElementById('gdprNotice');
    const gdprAccept = document.getElementById('gdprAccept');
    const gdprReject = document.getElementById('gdprReject');
    const gdprSettings = document.getElementById('gdprSettings');
    const gdprSettingsModal = document.getElementById('gdprSettingsModal');
    const gdprSettingsClose = document.getElementById('gdprSettingsClose');
    const gdprSettingsSave = document.getElementById('gdprSettingsSave');
    const analyticsConsent = document.getElementById('analyticsConsent');
    const marketingConsent = document.getElementById('marketingConsent');
    
    // GDPR durumunu kontrol et
    const gdprStatus = localStorage.getItem('gdpr_status');
    if (!gdprStatus) {
        gdprNotice.style.display = 'flex';
    } else {
        // Mevcut tercihleri yükle
        const preferences = JSON.parse(localStorage.getItem('gdpr_preferences') || '{}');
        analyticsConsent.checked = preferences.analytics || false;
        marketingConsent.checked = preferences.marketing || false;
    }
    
    // Kabul et butonuna tıklandığında
    gdprAccept.addEventListener('click', function() {
        const preferences = {
            analytics: true,
            marketing: true
        };
        localStorage.setItem('gdpr_status', 'accepted');
        localStorage.setItem('gdpr_preferences', JSON.stringify(preferences));
        gdprNotice.style.display = 'none';
    });
    
    // Reddet butonuna tıklandığında
    gdprReject.addEventListener('click', function() {
        const preferences = {
            analytics: false,
            marketing: false
        };
        localStorage.setItem('gdpr_status', 'rejected');
        localStorage.setItem('gdpr_preferences', JSON.stringify(preferences));
        gdprNotice.style.display = 'none';
        gdprSettingsModal.style.display = 'none';
    });
    
    // Ayarlar butonuna tıklandığında
    gdprSettings.addEventListener('click', function() {
        gdprSettingsModal.style.display = 'flex';
    });
    
    // Modal kapatma butonuna tıklandığında
    gdprSettingsClose.addEventListener('click', function() {
        gdprSettingsModal.style.display = 'none';
    });
    
    // Modal dışına tıklandığında
    gdprSettingsModal.addEventListener('click', function(e) {
        if (e.target === gdprSettingsModal) {
            gdprSettingsModal.style.display = 'none';
        }
    });
    
    // Ayarları kaydet butonuna tıklandığında
    gdprSettingsSave.addEventListener('click', function() {
        const preferences = {
            analytics: analyticsConsent.checked,
            marketing: marketingConsent.checked
        };
        localStorage.setItem('gdpr_status', 'customized');
        localStorage.setItem('gdpr_preferences', JSON.stringify(preferences));
        gdprNotice.style.display = 'none';
        gdprSettingsModal.style.display = 'none';
        
        // Analitik ve pazarlama çerezlerini tercihlere göre yönet
        if (!preferences.analytics) {
            // Google Analytics'i devre dışı bırak
            window['ga-disable-UA-XXXXXXXX-X'] = true;
        }
    });
});
</script>
<?php /**PATH /var/www/resources/views/components/gdpr-notice.blade.php ENDPATH**/ ?>