<!doctype html>
<meta http-equiv="content-type" content="text/html;charset=UTF-8" />
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <?php
    $seo = DB::table('seos')->where('site',6)->where('language',app()->getLocale())->first();
    $contact = DB::table('contact_infos')->where('site',6)->where('language',app()->getLocale())->first();
    $agreement = DB::table('agreements')->where('site',6)->where('language',app()->getLocale())->take(6)->get();
    $addvertise = DB::table('advertisings')->where('site',6)->orderBy('id','desc')->where('language',app()->getLocale())->first();
    $site       = DB::table('sites')->whereId('6')->first();

    ?>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title><?php echo $__env->yieldContent('title'); ?></title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="description" content="<?php echo html_entity_decode($seo?->description ); ?>"/>
    <meta name="author" content="Fatih CELIK">
    <meta name="keywords" content="<?php preg_match_all('/"value":"([^"]+)"/', stripslashes(json_decode($seo?->keywords ?? '')), $matches); echo implode(',', $matches[1] ?? []) ?? ''; ?>">
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset('assets/img/akdKurumsalwhite.png')); ?>">
    <!-- Place favicon.ico in the root directory -->
    <!-- CSS here -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/animate.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/magnific-popup.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/fontawesome-all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/flaticon.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/odometer.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/swiper-bundle.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/aos.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/default.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/main.css')); ?>">
  

    <!-- Swiper CSS -->
<link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/flag-icon-css/3.4.6/css/flag-icon.min.css">
    <?php echo $__env->yieldContent('css'); ?>
</head>
<body>
    <!--Preloader-->
    <div id="preloader">
        <div id="loader" class="loader">
            <div class="loader-container">
                <div class="loader-icon">
                    <img src="<?php echo e(asset('assets/img/bg/akd.png')); ?>" alt="Preloader">
                </div>
            </div>
        </div>
    </div>
    <!--Preloader-end -->
    <!-- Scroll-top -->
    <button class="scroll__top scroll-to-target" data-target="html">
        <i class="fas fa-angle-up"></i>
    </button>
    <!-- Scroll-top-end-->
    <!-- header-area -->
    <?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- header-area-end -->
    <!-- main-area -->
    <main class="fix">
        <?php echo $__env->yieldContent('content'); ?>
        <?php if(session('success')): ?>
        <script>
            toastr.success("<?php echo e(session('success')); ?>");
        </script>
    <?php endif; ?>
    <?php if($errors->any()): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <script>
                toastr.error("<?php echo e($error); ?>");
            </script>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
    </main>

    <?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('components.gdpr-notice', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- JS here -->
    <script src="<?php echo e(asset('assets/js/vendor/jquery-3.6.0.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.magnific-popup.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.odometer.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.appear.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/gsap.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/ScrollTrigger.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/SplitText.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/gsap-animation.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.parallaxScroll.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/swiper-bundle.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/ajax-form.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/wow.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/aos.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/main.js')); ?>"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
        <!-- Swiper JS -->
<script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>
    <script>
        const text = document.querySelector('.circle');
        text.innerHTML = text.textContent.replace(/\S/g, "<span>$&</span>");
        const element = document.querySelectorAll('.circle span');
        for (let i = 0; i < element.length; i++) {
            element[i].style.transform = "rotate(" + i * 17 + "deg)"
        }
    </script>
    <?php echo $__env->yieldContent('script'); ?>
</body>

</html>
<?php /**PATH /var/www/resources/views/layouts/app.blade.php ENDPATH**/ ?>