<?php

namespace Tests\Unit\Repositories;

use Tests\TestCase;
use App\Models\Quote;
use App\Repositories\QuoteRepository;
use Illuminate\Foundation\Testing\RefreshDatabase;

class QuoteRepositoryTest extends TestCase
{
    use RefreshDatabase;

    private QuoteRepository $repository;

    protected function setUp(): void
    {
        parent::setUp();
        $this->repository = new QuoteRepository(new Quote());
    }

    /** @test */
    public function it_can_create_a_quote()
    {
        $data = [
            'AdSoyad' => 'Test User',
            'SirketAdi' => 'Test Company',
            'Telefon' => '5551234567',
            'Email' => 'test@example.com',
            'Mesaj' => 'Test message',
            'visit_time' => time()
        ];

        $quote = $this->repository->createQuote($data);

        $this->assertInstanceOf(Quote::class, $quote);
        $this->assertEquals($data['AdSoyad'], $quote->AdSoyad);
        $this->assertEquals($data['SirketAdi'], $quote->SirketAdi);
        $this->assertEquals(config('app.site_id'), $quote->site);
        $this->assertEquals(app()->getLocale(), $quote->language);
    }

    /** @test */
    public function it_detects_spam_messages()
    {
        $currentTime = time();
        
        // Should be spam (less than 10 seconds)
        $this->assertTrue($this->repository->isSpam($currentTime - 5));
        
        // Should not be spam (more than 10 seconds)
        $this->assertFalse($this->repository->isSpam($currentTime - 15));
    }
}
